/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.polylib.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;

public class RadioButton
extends Button {
    private final List<RadioButton> otherButtons = new LinkedList<RadioButton>();
    private final List<Button.OnPress> actions = new LinkedList<Button.OnPress>();
    private float textScale = 1.0f;
    private boolean verticalText = false;
    private boolean pressed;

    public RadioButton(int x, int y, int width, int height, Component text) {
        super(x, y, width, height, text, e -> {});
    }

    public RadioButton withTextScale(float scale) {
        this.textScale = scale;
        return this;
    }

    public RadioButton withVerticalText() {
        this.verticalText = true;
        return this;
    }

    public RadioButton onPressed(Button.OnPress action) {
        this.actions.add(action);
        return this;
    }

    public void linkButtons(RadioButton ... buttons) {
        Collections.addAll(this.otherButtons, buttons);
        this.otherButtons.remove((Object)this);
    }

    public void m_5691_() {
        for (Button.OnPress action : this.actions) {
            action.m_93750_((Button)this);
        }
    }

    public void m_6305_(PoseStack pStack, int mouseX, int mouseY, float partialTicks) {
        if (!this.f_93624_) {
            return;
        }
        this.f_93622_ = this.pressed || mouseX >= this.f_93620_ && mouseY >= this.f_93621_ && mouseX < this.f_93620_ + this.f_93618_ && mouseY < this.f_93621_ + this.f_93619_;
        int textColor = 0xFFFFFF;
        int fillColor = 0x64000000;
        if (this.f_93622_) {
            textColor = 0xFFFFA0;
            fillColor = Integer.MIN_VALUE;
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RadioButton.m_93172_((PoseStack)pStack, (int)this.f_93620_, (int)this.f_93621_, (int)(this.f_93620_ + this.f_93618_), (int)(this.f_93621_ + this.f_93619_), (int)fillColor);
        Font font = Minecraft.m_91087_().f_91062_;
        Objects.requireNonNull(font);
        int lHeight = (int)(9.0f * this.textScale);
        pStack.m_85836_();
        pStack.m_85837_((double)this.f_93620_ + (double)lHeight / 2.0 + (double)this.f_93618_ / 2.0, (double)this.f_93621_ + ((double)this.f_93619_ - 8.0) / 2.0, 20.0);
        if (this.verticalText) {
            pStack.m_85845_(new Quaternion(-1.0f, 0.0f, 90.0f, true));
        }
        pStack.m_85841_(this.textScale, this.textScale, this.textScale);
        RadioButton.m_93215_((PoseStack)pStack, (Font)font, (Component)this.m_6035_(), (int)0, (int)0, (int)textColor);
        pStack.m_85849_();
    }

    public void m_5716_(double d, double e) {
        super.m_5716_(d, e);
        this.selectButton();
    }

    public void selectButton() {
        this.pressed = true;
        for (RadioButton button : this.otherButtons) {
            button.pressed = false;
        }
    }

    public void setPressed(boolean pressed) {
        this.pressed = pressed;
    }

    public boolean isPressed() {
        return this.pressed;
    }
}

